
{
    function mainOrganizer() {
        
        (function(){
            app.beginUndoGroup("Clean & Sort Project");

 
            function prepareName(name) {
                return name.toLowerCase().replace(/^\s+|\s+$/g, ''); 
            }
            

            function findTopLevelFolder(name){
                var lowerName = prepareName(name); 
                for(var i = 1; i <= app.project.numItems; i++){
                    var it = app.project.item(i);

                    if(it instanceof FolderItem && prepareName(it.name)===lowerName && it.parentFolder===app.project.rootFolder) return it;
                }
                return null;
            }
            

            function findSubFolder(name, parent){
                var lowerName = prepareName(name); 
                for(var i = 1; i <= app.project.numItems; i++){
                    var it = app.project.item(i);
                    if(it instanceof FolderItem && prepareName(it.name)===lowerName && it.parentFolder===parent) return it;
                }
                return null;
            }
            
   
            var mainFootage, mainSolids, mainComps, externalF;
            var precompF, mainCompF;
            var picF, vidF, dddF, vecF, sndF;


 
            function initFolders(){
                var existing;


                existing = findTopLevelFolder("Comps");
                if (existing) {mainComps = existing;} else {mainComps = app.project.items.addFolder("Comps");}

                existing = findTopLevelFolder("Footage");
                if (existing) {mainFootage = existing;} else {mainFootage = app.project.items.addFolder("Footage");}

                existing = findTopLevelFolder("Solids");
                if (existing) {mainSolids = existing;} else {mainSolids = app.project.items.addFolder("Solids");}
                
                existing = findTopLevelFolder("external Files");
                if (existing) {externalF = existing;} else {externalF = app.project.items.addFolder("external Files");}

  
                existing = findSubFolder("precomps", mainComps);
                if (existing) {
                    precompF = existing;
                } else {
                    precompF = app.project.items.addFolder("precomps");
                    precompF.parentFolder = mainComps;
                }
                
                existing = findSubFolder("Main", mainComps);
                if (existing) {
                    mainCompF = existing;
                } else {
                    mainCompF = app.project.items.addFolder("Main");
                    mainCompF.parentFolder = mainComps;
                }

 
                function subFolder(name){
                    var existingSub = findSubFolder(name, mainFootage);
                    if (existingSub) {
                        return existingSub;
                    } else {
                        var f = app.project.items.addFolder(name);
                        f.parentFolder = mainFootage;
                        return f;
                    }
                }

                picF = subFolder("Pictures");
                vidF = subFolder("Videos");
                dddF = subFolder("3D");
                vecF = subFolder("Vector");
                sndF = subFolder("Sound");
            }

          
            initFolders();

  
            var map = {
                "jpg":picF,"jpeg":picF,"png":picF,"tiff":picF,"heif":picF,"tdi":picF,
                "jpe":picF,"ei":picF,"psd":picF,"crw":picF,"nef":picF,"raf":picF,
                "orf":picF,"mrw":picF,"dcr":picF,"mos":picF,"raw":picF,"pef":picF,
                "srf":picF,"dng":picF,"x3f":picF,"cr2":picF,"erf":picF,"sr2":picF,
                "mfw":picF,"mef":picF,"arwund":picF,"pdf":picF,"cin":picF,"gif":picF,

                "mp4":vidF,"mov":vidF,"r3d":vidF,"crm":vidF,"mxf":vidF,"hevc":vidF,
                "3gp":vidF,"3g2":vidF,"amc":vidF,"flv":vidF,"f4v":vidF,"swf":vidF, 
                "m2ts":vidF,"m4v":vidF,"mpg":vidF,"m2p":vidF,"m2v":vidF,"m2a":vidF,
                "m2t":vidF,"omf":vidF,"avi":vidF,"wmv":vidF,"wma":vidF,"asf":vidF,
                "asx":vidF,

                "obj":dddF,"glb":dddF,"gltf":dddF,"exr":dddF,"sxr":dddF,"mxr":dddF,
                "c4d":dddF,"ma":dddF,

                "ai":vecF,"eps":vecF,"svg":vecF,

                "aac":sndF,"m4a":sndF,"aif":sndF,"aiff":sndF,"mp3":sndF,"mpeg":sndF,
                "mpa":sndF,"mpe":sndF,"wav":sndF,"bwf":sndF
            };

       
            for(var i = 1; i <= app.project.numItems; i++){
                var it = app.project.item(i);
    
                if(it instanceof CompItem || (it instanceof FootageItem && it.duration !== 0) || (it instanceof FootageItem && it.mainSource && it.mainSource.color)){
                    if(it.parentFolder !== app.project.rootFolder){
                         it.parentFolder = app.project.rootFolder; 
                    }
                }
            }


    
            var moved = 0;

            for(var i = 1; i <= app.project.numItems; i++){
                var it = app.project.item(i);
                
          
                if(it instanceof FolderItem) continue;

            
                if(it instanceof FootageItem && it.duration===0 && it.mainSource && it.mainSource.color){
                    if(it.parentFolder !== mainSolids){
                        it.parentFolder = mainSolids;
                        moved++;
                    }
                    continue;
                }

                if(it instanceof CompItem){
                
                    if(it.usedIn.length === 0 && it.parentFolder !== mainCompF){
                         it.parentFolder = mainCompF;
                         moved++;
                    } 
                   
                    else if (it.usedIn.length > 0 && it.parentFolder !== precompF){
                         it.parentFolder = precompF;
                         moved++;
                    }
                    continue;
                }

               
                if(!(it instanceof FootageItem)) continue;

                var ext = it.name.split(".").pop().toLowerCase();
                var target = map[ext];
                
            
                if(target && it.parentFolder !== target){
                    it.parentFolder = target;
                    moved++;
                }
                else if(!target && it.parentFolder !== externalF){
                    it.parentFolder = externalF;
                    moved++;
                }
            }

            app.endUndoGroup();

           
            var win = new Window("dialog", "Done");
            win.orientation = "column";
            win.alignChildren = "center";
            win.margins = 15;
            win.add("statictext", undefined, "Project sorted. Moved: " + moved + " items.");
            var okBtn = win.add("button", undefined, "OK");
            okBtn.onClick = function(){ win.close() };
            win.show();
        })();
        
    }
    

    function createUI(thisObj) {
        var myPanel = (thisObj instanceof Panel) ? thisObj : new Window("palette", "Lukas Feldhoff Project Tools", undefined, { resizeable: true });
        myPanel.orientation = "column";
        myPanel.alignChildren = "center";
        myPanel.spacing = 10;
        myPanel.margins = 16;

        var btnSize = 65;
        
        var ICON_FOLDER_NAME = "medelfpv_scripts";

        var row = myPanel.add("group", undefined);
        row.orientation = "row";
        row.alignChildren = "center";
        
        row.spacing = 10; 
        row.alignment = "center"; 

        function getImagePath(imageName) {
            var scriptFile = new File($.fileName);
            var scriptFolder = scriptFile.parent;
            
            var expectedPath = scriptFolder.fsName + "/" + ICON_FOLDER_NAME + "/" + imageName;
            var imgFile = new File(expectedPath);

            if (!imgFile.exists) {
                alert("⚠️ Icon not found! ⚠️\n\nThe Script cant find the image '" + imageName + "' under the path: \n\n" + expectedPath + "\n\nPlease make sure the folder '" + ICON_FOLDER_NAME + "' is still existing and the Icon Files ( '_hover.png' Versions as well) are a part of it.");
                return null;
            }
            return imgFile;
        }

        function createIconButton(parent, imageName, onClickFunction, tooltip) {
            var normalImageName = imageName;
            var hoverImageName = imageName.replace(".png", "_hover.png");

            var normalImgFile = getImagePath(normalImageName);
            var hoverImgFile = getImagePath(hoverImageName);

            var iconButton;
            
            if (normalImgFile && hoverImgFile) {
                try {
                    var normalPath = normalImgFile.fsName;
                    var hoverPath = hoverImgFile.fsName;

                    iconButton = parent.add("image", undefined, normalPath);
                    iconButton.size = [btnSize, btnSize];
                    
                    iconButton.addEventListener('mouseover', function() {
                        this.image = hoverPath;
                    });
                    
                    iconButton.addEventListener('mouseout', function() {
                        this.image = normalPath;
                    });

                    iconButton.addEventListener('mousedown', function() {
                        onClickFunction();
                    });

                    if (tooltip) {
                        iconButton.helpTip = tooltip;
                    }

                } catch (e) {
                    alert("⚠️ Fehler beim Laden der Icons für " + imageName + ": " + e.toString() + " ⚠️\n\nVersuche es mit einem Fallback-Button.");
                    iconButton = parent.add("button", undefined, tooltip || "");
                    iconButton.size = [btnSize, btnSize]; 
                    iconButton.onClick = onClickFunction;
                }
            } else {
                iconButton = parent.add("button", undefined, tooltip || "");
                iconButton.size = [btnSize, btnSize]; 
                iconButton.onClick = onClickFunction;
            }

            return iconButton;
        }

    
        function organizeFiles() {
            mainOrganizer();
            if (myPanel.layout) {
                myPanel.layout.layout(true);
            }
        }

        function clearCache() {
            app.executeCommand(10200); 
        }

        function openCachePreferences() {
            app.executeCommand(2439); 
        }

        function reduceProject() {
            var selectedItems = app.project.selection;
            if (selectedItems.length > 0 && selectedItems[0] instanceof CompItem) {
                try {
                    app.executeCommand(2735); 
                } catch (e) {
                    alert("⚠️ Failed to execute 'Reduce Project'. Please ensure the command ID is correct. ⚠️");
                }
            } else {
                alert("⚠️ Please select a composition in the Project panel before reducing the project. ⚠️");
            }
        }

        function collectAndSave() {
            app.executeCommand(2482); 
        }

   
        createIconButton(row, "Organize_Files.png", organizeFiles, "Organize Files");
        createIconButton(row, "Clear_Cache.png", clearCache, "Clear Cache");
        createIconButton(row, "Cache_Preferences.png", openCachePreferences, "Cache Preferences");
        createIconButton(row, "Reduce_Project.png", reduceProject, "Reduce Project");
        createIconButton(row, "Save_File.png", collectAndSave, "Collect & Save File");

        myPanel.onResizing = myPanel.onResize = function () {
            this.layout.resize();
        };

        if (myPanel instanceof Window) {
            myPanel.center();
            myPanel.show();
        } else {
            myPanel.layout.layout(true);
            myPanel.layout.resize();
        }

        return myPanel;
    }


    var scriptPanel = createUI(this);
}